/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.logic;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.transliterationlib.api.TRansliterationLib;
import dev.tr7zw.transliterationlib.api.event.RenderEvent;
import dev.tr7zw.transliterationlib.api.wrapper.entity.ClientPlayer;
import dev.tr7zw.transliterationlib.api.wrapper.item.ArmPose;
import dev.tr7zw.transliterationlib.api.wrapper.item.Hand;
import dev.tr7zw.transliterationlib.api.wrapper.item.Item;
import dev.tr7zw.transliterationlib.api.wrapper.item.ItemStack;
import dev.tr7zw.transliterationlib.api.wrapper.item.UseAction;
import dev.tr7zw.transliterationlib.api.wrapper.model.ModelWithArms;

public class HeldItemHandler {
    private Item filledMap = TRansliterationLib.transliteration.getEnumWrapper().getItems().getItem(TRansliterationLib.transliteration.constructors().newIdentifier("minecraft", "filled_map"));
    private Item crossbow = TRansliterationLib.transliteration.getEnumWrapper().getItems().getItem(TRansliterationLib.transliteration.constructors().newIdentifier("minecraft", "crossbow"));

    public void enable() {
        RenderEvent.RENDER_HELD_ITEM.register((entity, model, stack, arm, matrices, vertexConsumers, light, info) -> {
            if (entity.isSleeping()) {
                info.cancel();
                return;
            }
            if (NEAnimationsLoader.config.enableInWorldMapRendering && model instanceof ModelWithArms && NEAnimationsLoader.config.enableIngameMapHolding) {
                if (arm == entity.getMainArm() && entity.getMainHandStack().getItem().equals(this.filledMap)) {
                    matrices.push();
                    ((ModelWithArms)model).setArmAngle(arm, matrices);
                    matrices.multiply(TRansliterationLib.transliteration.singletonWrapper().getVector3f().getPositiveX().getDegreesQuaternion(-90.0f));
                    matrices.multiply(TRansliterationLib.transliteration.singletonWrapper().getVector3f().getPositiveY().getDegreesQuaternion(200.0f));
                    boolean bl = arm.equals(arm.getLeft());
                    matrices.translate((double)((float)(bl ? -1 : 1) / 16.0f), 0.125, -0.625);
                    TRansliterationLib.transliteration.getWrapper().renderFirstPersonMap(matrices, vertexConsumers, light, stack, !entity.getOffHandStack().isEmpty(), entity.getMainArm().equals(arm.getLeft()));
                    matrices.pop();
                    info.cancel();
                    return;
                }
                if (arm != entity.getMainArm() && entity.getOffHandStack().getItem().equals(this.filledMap)) {
                    matrices.push();
                    ((ModelWithArms)model).setArmAngle(arm, matrices);
                    matrices.multiply(TRansliterationLib.transliteration.singletonWrapper().getVector3f().getPositiveX().getDegreesQuaternion(-90.0f));
                    matrices.multiply(TRansliterationLib.transliteration.singletonWrapper().getVector3f().getPositiveY().getDegreesQuaternion(200.0f));
                    boolean bl = arm.equals(arm.getLeft());
                    matrices.translate((double)((float)(bl ? -1 : 1) / 16.0f), 0.125, -0.625);
                    TRansliterationLib.transliteration.getWrapper().renderFirstPersonMap(matrices, vertexConsumers, light, stack, true, false);
                    matrices.pop();
                    info.cancel();
                    return;
                }
            }
            if (NEAnimationsLoader.config.enableOffhandHiding && entity instanceof ClientPlayer) {
                ClientPlayer player = (ClientPlayer)entity;
                ArmPose armPose = this.getArmPose(player, TRansliterationLib.transliteration.getEnumWrapper().getHand().getMainHand());
                ArmPose armPose2 = this.getArmPose(player, TRansliterationLib.transliteration.getEnumWrapper().getHand().getOffHand());
                if (!this.isUsingboothHands(armPose) && !this.isUsingboothHands(armPose2)) {
                    return;
                }
                if (armPose.isTwoHanded()) {
                    ArmPose armPose3 = armPose2 = player.getOffHandStack().isEmpty() ? ArmPose.EMPTY : ArmPose.ITEM;
                }
                if (player.getMainArm().equals(arm.getRight())) {
                    if (arm.equals(arm.getRight()) && this.isUsingboothHands(armPose2)) {
                        info.cancel();
                        return;
                    }
                    if (arm.equals(arm.getLeft()) && this.isUsingboothHands(armPose)) {
                        info.cancel();
                        return;
                    }
                } else {
                    if (arm.equals(arm.getLeft()) && this.isUsingboothHands(armPose2)) {
                        info.cancel();
                        return;
                    }
                    if (arm.equals(arm.getRight()) && this.isUsingboothHands(armPose)) {
                        info.cancel();
                        return;
                    }
                }
            }
        });
    }

    private boolean isUsingboothHands(ArmPose pose) {
        return pose == ArmPose.BOW_AND_ARROW || pose == ArmPose.CROSSBOW_CHARGE || pose == ArmPose.CROSSBOW_HOLD;
    }

    private ArmPose getArmPose(ClientPlayer abstractClientPlayerEntity, Hand hand) {
        ItemStack itemStack = abstractClientPlayerEntity.getStackInHand(hand);
        if (itemStack.isEmpty()) {
            return ArmPose.EMPTY;
        }
        if (abstractClientPlayerEntity.getActiveHand() == hand && abstractClientPlayerEntity.getItemUseTime() > 0) {
            UseAction useAction = itemStack.getUseAction();
            if (useAction.equals(useAction.getBlock())) {
                return ArmPose.BLOCK;
            }
            if (useAction.equals(useAction.getBow())) {
                return ArmPose.BOW_AND_ARROW;
            }
            if (useAction.equals(useAction.getSpear())) {
                return ArmPose.THROW_SPEAR;
            }
            if (useAction.equals(useAction.getCrossbow()) && hand.equals(abstractClientPlayerEntity.getActiveHand())) {
                return ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!abstractClientPlayerEntity.isHandSwinging() && itemStack.getItem().equals(this.crossbow) && TRansliterationLib.transliteration.getWrapper().isChargedCrossbow(itemStack)) {
            return ArmPose.CROSSBOW_HOLD;
        }
        return ArmPose.ITEM;
    }
}

